unit IWCompMPEG;

interface

uses
  {$IFDEF VSNET}System.ComponentModel, System.Drawing, {$ENDIF}
  Classes,
  IWFileReference, IWCompObject, IWGlobal, IWHTMLTag, IWRenderContext;

type
  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWMPEG.bmp}  
  TIWMPEG = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWMPEG), 'TIWMPEG.bmp')]
  {$ENDIF}
  TIWMPEG = class(TIWCustomObject)
  protected
    FMPEGFile: TIWFileReference;

    procedure SetMPEGFile(const Value: TIWFileReference);
    procedure DoFileReferenceChange(Sender : TObject);

    procedure InitControl; override;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ENDIF}
    property MPEGFile: TIWFileReference read FMPEGFile write SetMPEGFile;
    property Archive;
    property ClassID;
    property CodeBase;
    property CodeType;
    property Data;
    property Declare;
    property FriendlyName;   
    property ObjectType;
    property PluginsPage;
    property RenderEMBED;
    property StandBy;
  end;


implementation

uses
  SysUtils;

{ TIWMPEG }

procedure TIWMPEG.InitControl;
begin
  inherited;
  FMPEGFile := TIWFileReference.Create;
  FRenderEMBED := False;
  FMPEGFile.OnChange := DoFileReferenceChange;
end;

procedure TIWMPEG.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FMPEGFile);
  inherited;
end;

procedure TIWMPEG.DoFileReferenceChange(Sender: TObject);
begin
  if not (csDesigning in ComponentState) then
  begin
     CodeBase := GServerController.FilesURL;
     Data := MPEGFile.Location(CodeBase);
  end;
end;

function TIWMPEG.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  Result := inherited RenderHTML(AContext);

  if RenderEMBED then
  begin
     Result.AddStringParam('SRC', MPEGFile.Location(GServerController.FilesURL));
     FFileReference := MPEGFile.Location(GServerController.FilesURL)
  end;
end;
procedure TIWMPEG.SetMPEGFile(const Value: TIWFileReference);
begin
  FMPEGFile.Assign(Value);
  FFileReference := Value.Location(GServerController.FilesURL);
end;

end.
